﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;

namespace Snake__Teil_4_
{
    class Program
    {
        // Voreinstellungen (Konstanten)
        // =============================
        // Fenstergröße festlegen
        const int windowWidth = 80;
        const int windowHeight = 40;

        // Unterer Rand für Spielinfos
        const int bottomBorder = 10;

        // Hintergrundfarbe Spielfeld
        const ConsoleColor gameBackgroundColor = ConsoleColor.White;

        // Vordergrundfarbe Spielfeldrand
        const ConsoleColor gameBorderColor = ConsoleColor.Black;

        // Zeichen für Spielfeldrand
        const char gameBorderCharacter = '#';

        // Maximale Länge der Schlange
        const int maxLengthOfSnake = 250;

        // Zeichen für Schlangenkörper
        const char snakeBodyCharacter = 'S';

        // Maximale Anzahl von Futterhappen
        const int maxAmountOfSnakeFood = 30;

        // Zeichen für Futterhappen
        const char snakeFoodCharacter = 'O';

        static void Main(string[] args)
        {
            // =============================================
            // Variablen
            // =============================================
            // Zum Ziehen von Zufallszahlen für Futterhappen
            Random randomNumbersGenerator = new Random();

            // =============================================
            // Informationen zum Spiel
            // =============================================
            // Ist das Spiel noch aktiv?
            bool isGameActive = false;

            // Wurde eine Begrenzung oder der 
            // Schlangenkörper getroffen ?
            bool isBorderOrBodyHit = false;
            
            // Erreichte Spielpunkte
            int points = 0;
            // =============================================

            // =============================================
            // Informationen zur Anzeige
            // =============================================
            // Der Inhalt dieses Arrays wird zur Darstellung
            // der aktuellen Spielsituation ausgegeben
            // gameArea[rows, columns]
            char[,] gameArea = new char[windowHeight - bottomBorder, windowWidth];
            // =============================================

            // =============================================
            // Informationen zur Schlange
            // =============================================
            // Enthält die Positionen des Schlangenkopfes 
            // und Schlangenkörpers als Zeilen/Spalten Wertepaare
            // Die Werte müssen größer 0 sein
            int[,] positionsOfSnake = new int[maxLengthOfSnake, 2];

            // Aktuelle Gesamtlänge der Schlange
            int lengthOfSnake = 4;

            // Aktuelle Bewegungsrichtung der Schlange
            // 1: Links, 2: Aufwärts, 3: Rechts, 4: Abwärts
            int directionOfSnake = 2;

            // Letzte Position des Schlangenendes
            int[,] lastPositionOfSnakeTail = new int[1, 2];
            // =============================================

            // =============================================
            // Informationen zu den Futterhappen
            // =============================================
            // Enthält die Position und Wert aller Futterhappen
            // Maximal 100 Futterhappen sind möglich
            // positionsOfSnakeFood[row, column, value]
            int[,] positionsOfSnakeFood = new int[maxAmountOfSnakeFood, 3];

            // Anzahl der Futterhappen
            int amountOfSnakeFood = 0;
            // =============================================

            // =============================================
            // Initialisierung des Spiels
            // Fenster initialisieren
            initializeWindow();

            // Spielfeld initialisiere
            initializeGameArea(gameArea);

            // Startpositionen der Schlange
            initializeSnakePosition(positionsOfSnake, lengthOfSnake);

            // Schlange in Array eintragen
            drawSnake(positionsOfSnake, lengthOfSnake, gameArea);
            // =============================================

            // =============================================
            // Beginn der Spiellogik
            // =============================================
            // Spiel starten
            isGameActive = true;
            // Inhalt des Spielfeldes und Statusinformationen
            // auf Bildschirm ausgeben
            drawScreen(gameArea);

            // Ablauf des Spieles
            do
            {
                // Wartezeit
                Thread.Sleep(100);

                // Bestimme die gewählte Richtung der Schlange
                directionOfSnake = checkKeyboardAndSetNewDirection(directionOfSnake);

                // Bewege die Schlange an die neue Position
                // im Spielfeld
                moveSnake(positionsOfSnake, lengthOfSnake, directionOfSnake, lastPositionOfSnakeTail);

                // Prüfe, ob der Schlangenkopf einen
                // Futterhappen getroffen hat und liefere dessen Wert
                // und die neue Anzahl Futterhappen zurück
                int[] snakeFoodInfo = checkForSnakeFood(positionsOfSnakeFood,
                                                        amountOfSnakeFood,
                                                        positionsOfSnake);

                int newAmountOfSnakeFood = snakeFoodInfo[0];
                int newPoints = snakeFoodInfo[1];

                // Wenn ein Futterhappen gefressen wurde:
                // Aktualisiere: Menge der Futterhappen
                //               Erreichte Punktezahl
                //               Länge der Schlange
                if (newAmountOfSnakeFood < amountOfSnakeFood)
                {
                    amountOfSnakeFood = newAmountOfSnakeFood;
                    points += newPoints;
                    lengthOfSnake = addSnakePartToEnd(positionsOfSnake, lengthOfSnake, lastPositionOfSnakeTail);
                }
                else
                {
                    // Falls kein Futterhappen gefressen wurde:
                    // Wurde der Rand oder der Schlangenkörper getroffen?
                    isBorderOrBodyHit = checkCollisionWithBorderOrSnakeBody(positionsOfSnake, gameArea);
                    // Spiel stoppt, wenn Rand getroffen wurde
                    isGameActive = !isBorderOrBodyHit;
                }

                // Lösche das Spielfeld ohne Rand
                clearGameArea(gameArea);

                // Eintragen der Position der Schlange im Spielfeld
                drawSnake(positionsOfSnake, lengthOfSnake, gameArea);

                // Futterhappen erzeugen
                amountOfSnakeFood = createSnakeFood(randomNumbersGenerator,
                                                  positionsOfSnake,
                                                  lengthOfSnake,
                                                  positionsOfSnakeFood,
                                                  amountOfSnakeFood);

                // Eintragen der Position der Futterhappen im Spielfeld
                drawSnakeFood(positionsOfSnakeFood, amountOfSnakeFood, gameArea);

                // Inhalt des Spielfeldes auf dem Bildschirm ausgeben
                drawScreen(gameArea);
            }
            while (isGameActive == true);

        }

        // Methoden zu Initialisierung
        // =======================================================
        // Konsolenfenster initialisieren
        static void initializeWindow()
        {
            // Fenster einstellen
            Console.SetWindowSize(1, 1);
            Console.SetBufferSize(windowWidth, windowHeight);
            Console.SetWindowSize(windowWidth, windowHeight);
            Console.Title = "Snake (by Uwe Homm)";

            Console.BackgroundColor = gameBackgroundColor;
            Console.CursorVisible = false;
            Console.Clear();
        }

        // Spielfeld initialisieren
        static void initializeGameArea(char[,] gameArea)
        {
            // Array mit Leerzeichen vorbelegen
            for (int row = 0; row < windowHeight - bottomBorder; row++)
            {
                for (int column = 0; column < windowWidth; column++)
                {
                    gameArea[row, column] = ' ';
                }
            }
            // Zeichnen der Spielfeldumrandung
            // Oberen und unteren Rand zeichnen
            for (int xPos = 0; xPos < windowWidth; xPos++)
            {
                gameArea[0, xPos] = gameBorderCharacter;
                gameArea[windowHeight - bottomBorder - 1, xPos] = gameBorderCharacter;
            }

            // Linken und rechten Rand zeichnen
            for (int yPos = 1; yPos < windowHeight - bottomBorder - 1; yPos++)
            {
                Console.SetCursorPosition(0, yPos);
                gameArea[yPos, 0] = gameBorderCharacter;
                gameArea[yPos, windowWidth - 1] = gameBorderCharacter;
            }
        }

        // Anfangsposition der Schlange initialisieren
        static void initializeSnakePosition(int[,] positionsOfSnake,
                                            int lengthOfSnake)
        {
            // Kopf in der Mitte
            int row = (windowHeight - bottomBorder) / 2;
            int column = windowWidth / 2;

            // Position Körper speichern
            for (int i = 0; i < lengthOfSnake; i++)
            {
                positionsOfSnake[i, 0] = row;
                positionsOfSnake[i, 1] = column + i;
            }
        }

        // Methoden zur Spiellogik
        // =======================================================
        // Gibt den Inhalt des Spielfeldes im Fenster aus
        static void drawScreen(char[,] gameArea)
        {
            // Einstellen der Farben im Konsolenfenster
            Console.BackgroundColor = gameBackgroundColor;
            Console.ForegroundColor = gameBorderColor;

            // Hier wird der gesamte Inhalt des Array gameArea
            // tatsächlich in das Fenster geschrieben
            for (int row = 0; row < windowHeight - bottomBorder; row++)
            {
                for (int column = 0; column < windowWidth; column++)
                {
                    Console.SetCursorPosition(column, row);
                    Console.Write(gameArea[row, column]);
                }
            }
        }

        // Überträgt die Position der Schlange in das Spielfeld
        static void drawSnake(int[,] positionsOfSnake, 
                              int lengthOfSnake,
                              char[,] gameArea)
        {
            // Den Schlangenkörper in die Spielsituation eintragen
            for (int i = 0; i < lengthOfSnake; i++)
            {
                // Zeile und Spalte ermitteln
                int row = positionsOfSnake[i, 0];
                int column = positionsOfSnake[i, 1];
                // Zeichen für Schlange an der Position eintragen
                gameArea[row, column] = snakeBodyCharacter;

                // Kompakter, aber schwerer lesbar!
                // gameArea[positionsOfSnake[i, 0], positionsOfSnake[i, 1]] = snakeBodyCharacter;
            }
        }

        // Erzeugt einen neuen Futterhappen mit zufälliger Position 
        // im Spielfeld und gibt die aktuelle Anzahl der Futterhappen
        // zurück
        static int createSnakeFood(Random randomNumbersGenerator, int[,] positionsOfSnake,
                                   int lengthOfSnake, int[,] positionsOfSnakeFood,
                                   int amountOfSnakeFood)
        {
            // Keine neuen Futterhappen, wenn bereits Maximum erreicht
            if (amountOfSnakeFood >= maxAmountOfSnakeFood)
                return amountOfSnakeFood;

            // Drei Zufallszahlen für die Position
            // und den Wert des Futterhappens ziehen
            // Die Position soll innerhalb des
            // Spielfelds mit einem Abstand von 2
            // zum Rand sein
            // Somit liegt der Wert für x zwischen
            // 3 und 76 und für y zwischen 3 und 26
            // für die Größe 80x40

            int column = randomNumbersGenerator.Next(3, windowWidth - 3);
            int row = randomNumbersGenerator.Next(3, windowHeight -
                                                     bottomBorder - 3);
            int value = randomNumbersGenerator.Next(1, 11);

            // Ein Futterhappen darf nur auf
            // einem leeren Feld erzeugt werden!

            // Zuerst prüfen, ob die Position bereits
            // duch einen anderen Futterhappen belegt ist
            // Annahme: Position ist frei
            bool isPositionEmpty = true;
            // Alle Futterhappen durchlaufen
            for (int i = 0; i < amountOfSnakeFood; i++)
            {

                // Hat der Futterhappen die gleiche Position?
                if (positionsOfSnakeFood[i, 0] == row &&
                    positionsOfSnakeFood[i, 1] == column)
                {
                    // Position ist belegt
                    isPositionEmpty = false;
                    // Schleife vorzeitig beenden
                    break;
                }
            }

            // Falls kein Futterhappenposition
            if (isPositionEmpty)
            {
                // Prüfen, ob die Position bereits
                // duch den Schlangenkörper belegt ist
                for (int i = 0; i < lengthOfSnake; i++)
                {

                    if (positionsOfSnake[i, 0] == row &&
                        positionsOfSnake[i, 1] == column)
                    {
                        isPositionEmpty = false;
                        break;
                    }
                }
            }

            // Falls nicht, Futterhappen
            // am Ende hinzufügen und Anzahl inkrementieren
            if (isPositionEmpty == true)
            {
                positionsOfSnakeFood[amountOfSnakeFood, 0] = row;
                positionsOfSnakeFood[amountOfSnakeFood, 1] = column;
                positionsOfSnakeFood[amountOfSnakeFood, 2] = value;
                amountOfSnakeFood++;
            }

            return amountOfSnakeFood;
        }

        // Überträgt die Position der Futterhappen in das Spielfeld
        static void drawSnakeFood(int[,] positionsOfSnakeFood, int amountOfSnakeFood,
                                           char[,] gameArea)
        {
            for (int i = 0; i < amountOfSnakeFood; i++)
            {
                gameArea[positionsOfSnakeFood[i, 0], positionsOfSnakeFood[i, 1]] = snakeFoodCharacter;
            }

        }

        // Prüft, ob der Schlangenkopf einen Futterhappen
        // gefressen hat und liefert ein Array mit der 
        // aktuellen Anzahl der Futterhappen und dem Wert 
        // des gefressenen Futterhappens zurück
        static int[] checkForSnakeFood(int[,] positionsOfSnakeFood,
                                       int amountOfSnakeFood,
                                       int[,] positionsOfSnake)
        {
            // Zeile für Schlangenkopf
            int rowSnakeHead = positionsOfSnake[0, 0];
            // Spalte für Schlangenkopf
            int columnSnakeHead = positionsOfSnake[0, 1];

            // Wert eines gefressenen Futterhappens
            int valueOfSnakeFood = 0;

            // Prüfe, ob der Kopf auf einen Futterhappen gestoßen ist
            for (int i = 0; i < amountOfSnakeFood; i++)
            {
                if (positionsOfSnakeFood[i, 0] == rowSnakeHead &&
                    positionsOfSnakeFood[i, 1] == columnSnakeHead)
                {
                    Console.Beep();

                    // Wert des Futterhappens speichern
                    valueOfSnakeFood = positionsOfSnakeFood[i, 2];

                    // Gefressenen Futterhappen entfernen
                    // durch Verschieben der nachfolgenden
                    // um eine Position Richtung Beginn

                    for (int j = i; j < amountOfSnakeFood - 1; j++)
                    {
                        positionsOfSnakeFood[j, 0] = positionsOfSnakeFood[j + 1, 0];
                        positionsOfSnakeFood[j, 1] = positionsOfSnakeFood[j + 1, 1];
                        positionsOfSnakeFood[j, 2] = positionsOfSnakeFood[j + 1, 2];
                    }

                    // Letzten Futterhappen löschen
                    positionsOfSnakeFood[amountOfSnakeFood - 1, 0] = 0;
                    positionsOfSnakeFood[amountOfSnakeFood - 1, 1] = 0;
                    positionsOfSnakeFood[amountOfSnakeFood - 1, 2] = 0;

                    // Anzahl der Futterhappen dekrementieren
                    amountOfSnakeFood--;

                    // Weitere Prüfung beenden
                    break;
                }
            }

            // Diese Methode soll zwei Werte zurückliefern
            // Da immer nur genau ein Wert mit return
            // zurück gegeben werden kann, wird ein Array
            // verwendet, welches genau zwei Werte enthält:
            int[] snakeFoodInfo = new int[2];
            snakeFoodInfo[0] = amountOfSnakeFood;
            snakeFoodInfo[1] = valueOfSnakeFood;

            return snakeFoodInfo;
        }

        // Prüft, ob eine Taste gedrückt wurde und
        // stellt die Bewegungsrichtung der Schlange ein
        static int checkKeyboardAndSetNewDirection(int directionOfSnake)
        {
            // Rückgabewert für die Bewegungsrichtung der Schlange
            int newDirection = 0;

            // Prüfen, ob eine Taste gedrückt wurde
            if (Console.KeyAvailable)
            {
                // Liest die gedrückte Taste ohne Anzeige im Konsolenfenster
                ConsoleKeyInfo pressedKey = Console.ReadKey(false);

                // Auswertung der gedrückten Taste
                switch (pressedKey.Key)
                {
                    case ConsoleKey.LeftArrow:
                        newDirection = 1;
                        break;
                    case ConsoleKey.UpArrow:
                        newDirection = 2;
                        break;
                    case ConsoleKey.RightArrow:
                        newDirection = 3;
                        break;
                    case ConsoleKey.DownArrow:
                        newDirection = 4;
                        break;
                    case ConsoleKey.Escape:
                        Environment.Exit(1);
                        break;
                    default:
                        break;
                }

                // Falls ja, ist die neue Richtung ungleich der alten Richtung
                // und wurde eine Richtungstaste gedrückt?
                if (directionOfSnake != newDirection && newDirection >= 1 && newDirection <= 4)
                {
                    // Entgegen gesetzte Richtung verbieten
                    if (newDirection == 1 && !(directionOfSnake == 3))
                        directionOfSnake = newDirection;
                    else if (newDirection == 2 && !(directionOfSnake == 4))
                        directionOfSnake = newDirection;
                    else if (newDirection == 3 && !(directionOfSnake == 1))
                        directionOfSnake = newDirection;
                    else if (newDirection == 4 && !(directionOfSnake == 2))
                        directionOfSnake = newDirection;
                }
            }

            // Rückgabe der aktuellen Richtung
            return directionOfSnake;
        }
        
        // Legt die neue Position der Schlange anhand 
        // der aktuellen Richtung fest
        static void moveSnake(int[,] positionsOfSnake,
                              int lengthOfSnake,
                              int directionOfSnake,
                              int[,] lastPositionOfSnakeTail)
        {
            // Aktuelle Position des Schlangenkopf merken
            int[,] newPositionOfSnakeHead = new int[1, 2];
            newPositionOfSnakeHead[0, 0] = positionsOfSnake[0, 0];
            newPositionOfSnakeHead[0, 1] = positionsOfSnake[0, 1];

            // Aktuelle Position des Schlangenendes speichern
            lastPositionOfSnakeTail[0, 0] = positionsOfSnake[lengthOfSnake - 1, 0];
            lastPositionOfSnakeTail[0, 1] = positionsOfSnake[lengthOfSnake - 1, 1];

            // Neue Position des Schlangekopfes anhand
            // der Richtung festlegen
            switch (directionOfSnake)
            {
                // Links
                case 1:
                    newPositionOfSnakeHead[0, 1] -= 1;
                    break;
                // Aufwärts
                case 2:
                    newPositionOfSnakeHead[0, 0] -= 1;
                    break;
                // Rechts
                case 3:
                    newPositionOfSnakeHead[0, 1] += 1;
                    break;
                // Abwärts
                case 4:
                    newPositionOfSnakeHead[0, 0] += 1;
                    break;
            }

            // Aktuelle Position des Schlangenendes speichern
            // lastPositionOfSnakeTail[0, 0] = positionsOfSnake[lengthOfSnake - 1, 0];
            // lastPositionOfSnakeTail[0, 1] = positionsOfSnake[lengthOfSnake - 1, 1];

            // Hier wird nach einer Positionsänderung
            // die Lage der Schlange neu gespeichert

            // Verschieben der Schlangenkörperpositionen
            // beginnend am Ende
            for (int i = lengthOfSnake - 1; i > 0; i--)
            {
                positionsOfSnake[i, 0] = positionsOfSnake[i - 1, 0];
                positionsOfSnake[i, 1] = positionsOfSnake[i - 1, 1];
            }

            // Neue Position des Schlangenkopfes speichern
            positionsOfSnake[0, 0] = newPositionOfSnakeHead[0, 0];
            positionsOfSnake[0, 1] = newPositionOfSnakeHead[0, 1];
        }

        // Fügt ein neues Körperteil am Ende der Schlange hinzu
        static int addSnakePartToEnd(int[,] positionsOfSnake,
                                     int lengthOfSnake,
                                     int[,] lastPositionOfSnakeTail)
        {
            // Maximale Länge der Schlange erreicht?
            // Dann nicht verlängern
            if (lengthOfSnake >= maxLengthOfSnake)
                return lengthOfSnake;

            // Wurde ein Futterhapen gefressen, wird das
            // alte Schwanzende an die Schlange als
            // neues Arrayelement angehöngt

            // Zeile
            positionsOfSnake[lengthOfSnake, 0] = lastPositionOfSnakeTail[0, 0];
            // spalte
            positionsOfSnake[lengthOfSnake, 1] = lastPositionOfSnakeTail[0, 1];

            lengthOfSnake++;

            return lengthOfSnake;
        }
        
        // Lösche das Spielfeld ohne Rand
        static void clearGameArea(char[,] gameArea)
        {
            // Array mit Leerzeichen vorbelegen
            for (int row = 1; row < windowHeight - bottomBorder - 1; row++)
            {
                for (int column = 1; column < windowWidth - 2; column++)
                {
                    gameArea[row, column] = ' ';
                }
            }
        }

        // Prüft, ob der Schlangenkopf den Spielfeldrand
        // oder den Schlangenkörper getroffen hat
        static bool checkCollisionWithBorderOrSnakeBody(int[,] positionsOfSnake,
                                                        char[,] gameArea)
        {
            bool isBorderOrBodyHit = false;

            // Zeile für Schlangenkopf
            int rowSnakeHead = positionsOfSnake[0, 0];
            // Spalte für Schlangenkopf
            int columnSnakeHead = positionsOfSnake[0, 1];

            // Prüfe, ob der Kopf auf einen Rand oder auf den Körper stößt
            if (gameArea[rowSnakeHead, columnSnakeHead] == gameBorderCharacter ||
                gameArea[rowSnakeHead, columnSnakeHead] == snakeBodyCharacter)
            {
                Console.Beep();
                Console.Beep();
                isBorderOrBodyHit = true;
            }

            return isBorderOrBodyHit;
        }
    }
}
